<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
	xmlns:ta1="http://www.sec.gov/edgar/ta/taonefiler">

	<xsl:template name="item1_registration">
		<h1>
			<xsl:value-of select="$submissionType" />
			: Registrant Information
		</h1>
		<table role="presentation" class="registration">
			<tr>
				<td class="label">
					<font color="black">
						<b>2.</b>
						Appropriate regulatory agency (check one):
					</font>
				</td>
				<td>
					<div style="FONT-WEIGHT: normal" align="left">						
							<xsl:choose>
								<xsl:when test="ta1:formData/ta1:registrant/ta1:regulatoryAgency = 'SEC'">
									<img src="Images/radio-checked.jpg" alt="radio button checked" />
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								</xsl:otherwise>
							</xsl:choose>
							&#160;
							<font color="black">Securities and Exchange Commission</font>
							&#160;
							<xsl:choose>

								<xsl:when test="ta1:formData/ta1:registrant/ta1:regulatoryAgency = 'FDIC'">
									<img src="Images/radio-checked.jpg" alt="radio button checked" />
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								</xsl:otherwise>
							</xsl:choose>
							&#160;
							<font color="black">Federal Deposit Insurance Corporation</font>
							&#160;
							<xsl:choose>
								<xsl:when test="ta1:formData/ta1:registrant/ta1:regulatoryAgency = 'CC'">
									<img src="Images/radio-checked.jpg" alt="radio button checked" />
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
								</xsl:otherwise>
							</xsl:choose>
							&#160;
							<font color="black">Comptroller of the Currency</font>
							&#160;
					</div>
				</td>
			</tr>
		</table>
		<table role="presentation" class="registration">
			<tr>
				<td class="label">
					<font face="Times New Roman">
						<b>3(a). </b>
					</font>
					Full Name of Registrant:
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="ta1:formData/ta1:registrant/ta1:entityName" />
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<font face="Times New Roman">
						<b>3(a)(i). </b>
					</font>
					Previous name, if being amended:
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="ta1:formData/ta1:registrant/ta1:previousEntityName" />
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<font face="Times New Roman">
						<b>3(b). </b>
					</font>
					Financial Industry Number (FINS) number:
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="ta1:formData/ta1:registrant/ta1:finsNumber" />
					</div>
				</td>
			</tr>
		</table>
		<p>
			<b>3(c). </b>
			Address of principal office where transfer agent activities are, or
			will be, performed:
		</p>
		<table role="presentation" class="registration">
			<tr>
				<td class="label">
					<font face="Times New Roman">
						<b>3(c)(i). </b>
					</font>
					Address 1
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="ta1:formData/ta1:registrant/ta1:principalOfficeAddress/ta1:street1" />
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<font face="Times New Roman">
						<b>3(c)(ii). </b>
					</font>
					Address 2
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="ta1:formData/ta1:registrant/ta1:principalOfficeAddress/ta1:street2" />
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<font face="Times New Roman">
						<b>3(c)(iii). </b>
					</font>
					City
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="ta1:formData/ta1:registrant/ta1:principalOfficeAddress/ta1:city" />
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<font face="Times New Roman">
						<b>3(c)(iv). </b>
					</font>
					State or Country
				</td>
				<td>
					<div class="fakeBox">
						<xsl:call-template name="stateDescription">
							<xsl:with-param name="stateCode"
								select="ta1:formData/ta1:registrant/ta1:principalOfficeAddress/ta1:stateOrCountry" />
						</xsl:call-template>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<font face="Times New Roman">
						<b>3(c)(v). </b>
					</font>
					Postal Code
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="ta1:formData/ta1:registrant/ta1:principalOfficeAddress/ta1:zipCode" />
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<b>
						<font face="Times New Roman">3(d). </font>
					</b>
					Is Mailing address different from response to Question 3c?
					If &#34;yes&#34; provide address(es):
				</td>
				<td>
						<xsl:choose>
							<xsl:when test="ta1:formData/ta1:registrant/ta1:differentMailingAddress = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;Yes&#160;
						<xsl:choose>
							<xsl:when test="ta1:formData/ta1:registrant/ta1:differentMailingAddress = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;No
				</td>
			</tr>
			<xsl:if test="ta1:formData/ta1:registrant/ta1:differentMailingAddress = 'Y'">
				<tr>
					<td class="label">
						<font face="Times New Roman">
							<b>3(d)(i). </b>
						</font>
						Address 1
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="ta1:formData/ta1:registrant/ta1:mailingAddress/ta1:street1" />
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<font face="Times New Roman">
							<b>3(d)(ii). </b>
						</font>
						Address 2
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="ta1:formData/ta1:registrant/ta1:mailingAddress/ta1:street2" />
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<font face="Times New Roman">
							<b>3(d)(iii). </b>
						</font>
						City
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="ta1:formData/ta1:registrant/ta1:mailingAddress/ta1:city" />
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<font face="Times New Roman">
							<b>3(d)(iv). </b>
						</font>
						State or Country
					</td>
					<td>
						<div class="fakeBox">
							<xsl:call-template name="stateDescription">
								<xsl:with-param name="stateCode"
									select="ta1:formData/ta1:registrant/ta1:mailingAddress/ta1:stateOrCountry" />
							</xsl:call-template>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<font face="Times New Roman">
							<b>3(d)(v). </b>
						</font>
						Postal Code
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="ta1:formData/ta1:registrant/ta1:mailingAddress/ta1:zipCode" />
						</div>
					</td>
				</tr>
			</xsl:if>
			<tr>
				<td class="label">
					<font face="Times New Roman">
						<b>3(e). </b>
					</font>
					Telephone Number (Include Area Code)
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="ta1:formData/ta1:registrant/ta1:telephoneNumber" />
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<b>
						<font face="Times New Roman">4. </font>
					</b>
					Does Registrant conduct, or will it conduct, transfer agent
					activities at any location other than that given in Questions
					3(c) above? If &#34;Yes&#34; provide address (es):
				</td>
				<td>
						<xsl:choose>
							<xsl:when test="ta1:formData/ta1:registrant/ta1:conductBusinessInOtherLocations = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;Yes&#160;
						<xsl:choose>
							<xsl:when test="ta1:formData/ta1:registrant/ta1:conductBusinessInOtherLocations = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;No
				</td>
			</tr>
			<xsl:if test="ta1:formData/ta1:registrant/ta1:conductBusinessInOtherLocations='Y'">
				<xsl:for-each select="ta1:formData/ta1:registrant/ta1:otherBusinessLocation">
					<xsl:call-template name="mode_otherBusiness" />
				</xsl:for-each>
			</xsl:if>
			<tr>
				<td class="label">
					<b>
						<font face="Times New Roman">5. </font>
					</b>
					Does registrant act, or will it act,
					as a transfer agent solely for its own securities,
					and/or securities of an affiliate(s)?
				</td>
				<td>
						<xsl:choose>
							<xsl:when test="ta1:formData/ta1:registrant/ta1:selfTransferAgent = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;Yes&#160;
						<xsl:choose>
							<xsl:when test="ta1:formData/ta1:registrant/ta1:selfTransferAgent = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;No
				</td>
			</tr>
			<tr>
				<td class="label">
					<b>
						<font face="Times New Roman">6. </font>
					</b>
					Has registrant, as a named transfer agent, engaged, or will it
					engage, a service company to perform any transfer agent functions?
				</td>
				<td>
						<xsl:choose>
							<xsl:when test="ta1:formData/ta1:registrant/ta1:engagedServiceCompany = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;Yes&#160;
						<xsl:choose>
							<xsl:when test="ta1:formData/ta1:registrant/ta1:engagedServiceCompany = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;No
				</td>
			</tr>
			</table>
			<xsl:if test="ta1:formData/ta1:registrant/ta1:engagedServiceCompany='Y'">
         <p></p>
							If "yes," provide the name(s) and address(es) of all
							service
							companies engaged, or that will be engaged, by the registrant
							to perform its transfer agent functions:

				<xsl:for-each select="ta1:formData/ta1:registrant/ta1:serviceCompany">
					<xsl:call-template name="mode_serviceCompany" />
				</xsl:for-each>
			</xsl:if>
			
		<table role="presentation">			
			<tr>
				<td class="label">
					<b>
						<font face="Times New Roman">7. </font>
					</b>
					Has registrant been engaged, or will it be engaged as a service
					company by a named transfer agent to perform transfer agent
					functions?
				</td>
				<td>
						<xsl:choose>
							<xsl:when test="ta1:formData/ta1:registrant/ta1:engagedAsServiceCompany = 'Y'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;Yes&#160;
						<xsl:choose>
							<xsl:when test="ta1:formData/ta1:registrant/ta1:engagedAsServiceCompany = 'N'">
								<img src="Images/radio-checked.jpg" alt="radio button checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="radio button unchecked" />
							</xsl:otherwise>
						</xsl:choose>
						&#160;No
				</td>
			</tr>
			</table>
			<xsl:if test="ta1:formData/ta1:registrant/ta1:engagedAsServiceCompany='Y'">
          <p></p>
							If "Yes" provide the name(s) and File Number(s) of the
							named transfer agent(s) for which the registrant has been
							engaged, or will be engaged, as a service company to perform
							transfer agent functions:

				<xsl:for-each select="ta1:formData/ta1:registrant/ta1:asServiceCompany">
					<xsl:call-template name="mode_asServiceCompany" />
				</xsl:for-each>

			</xsl:if>
	
	</xsl:template>
	<xsl:template name="mode_otherBusiness" match="ta1:registrant"
		mode="_otherBusiness">
		<tr>
			<td class="label">
				Other Business Location Record:
				<xsl:value-of select="position()" />
			</td>
			<td>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>4(a)(i). </b>
				</font>
				Address 1
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:street1" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>4(a)(ii). </b>
				</font>
				Address 2
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:street2" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>4(a)(iii). </b>
				</font>
				City
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:value-of select="ta1:city" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>4(a)(iv). </b>
				</font>
				State or Country
			</td>
			<td>
				<div class="fakeBox">
					<xsl:call-template name="stateDescription">
						<xsl:with-param name="stateCode" select="ta1:stateOrCountry" />
					</xsl:call-template>
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>4(a)(v). </b>
				</font>
				Postal Code
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:value-of select="ta1:zipCode" />
				</div>
			</td>
		</tr>
	</xsl:template>
	<xsl:template name="mode_serviceCompany" match="ta1:registrant"
		mode="_serviceCompany">
        <p></p>
				Engaged sevice company information Related to item 6 Record:
           	<xsl:value-of select="position()" />
  	<table role="presentation">	
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>6(a). </b>
				</font>
				Name
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:entityName" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>6(b). </b>
				</font>
				File Number
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:call-template name="FileNoLink" >
						<xsl:with-param name="aFileNumber" select="ta1:fileNumber"></xsl:with-param>
						<xsl:with-param name="label" select="ta1:fileNumber"></xsl:with-param>									
					</xsl:call-template>
				</div>				
			</td>
		</tr>

		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>6(c)(i). </b>
				</font>
				Address 1
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:serviceCompanyAddress/ta1:street1" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>6(c)(ii). </b>
				</font>
				Address 2
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:serviceCompanyAddress/ta1:street2" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>6(c)(iii). </b>
				</font>
				City
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:value-of select="ta1:serviceCompanyAddress/ta1:city" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>6(c)(iv). </b>
				</font>
				State or Country
			</td>
			<td>
				<div class="fakeBox">
					<xsl:call-template name="stateDescription">
						<xsl:with-param name="stateCode"
							select="ta1:serviceCompanyAddress/ta1:stateOrCountry" />
					</xsl:call-template>
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>6(c)(v). </b>
				</font>
				Postal Code
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:value-of select="ta1:serviceCompanyAddress/ta1:zipCode" />
				</div>
			</td>
		</tr>
	</table>	
	</xsl:template>

	<xsl:template name="mode_asServiceCompany" match="ta1:registrant"
		mode="_asServiceCompany">
     <p></p>
				Engaged transfer agent company information Related to item 7 Record:
				<xsl:value-of select="position()" />
 		<table role="presentation">	
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>7(a). </b>
				</font>
				Name
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:entityName" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>7(b). </b>
				</font>
				File Number
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:call-template name="FileNoLink" >
						<xsl:with-param name="aFileNumber" select="ta1:fileNumber"></xsl:with-param>
						<xsl:with-param name="label" select="ta1:fileNumber"></xsl:with-param>									
					</xsl:call-template>
				</div>	
			</td>
		</tr>

		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>7(c)(i). </b>
				</font>
				Address 1
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:asServiceCompanyAddress/ta1:street1" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>7(c)(ii). </b>
				</font>
				Address 2
			</td>
			<td>
				<div class="fakeBox">
					<xsl:value-of select="ta1:asServiceCompanyAddress/ta1:street2" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>7(c)(iii). </b>
				</font>
				City
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:value-of select="ta1:asServiceCompanyAddress/ta1:city" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>7(c)(iv). </b>
				</font>
				State or Country
			</td>
			<td>
				<div class="fakeBox">
					<xsl:call-template name="stateDescription">
						<xsl:with-param name="stateCode"
							select="ta1:asServiceCompanyAddress/ta1:stateOrCountry" />
					</xsl:call-template>
				</div>
			</td>
		</tr>
		<tr>
			<td class="label">
				<font face="Times New Roman">
					<b>7(c)(v). </b>
				</font>
				Postal Code
			</td>
			<td>
				<div class="fakeBox2">
					<xsl:value-of select="ta1:asServiceCompanyAddress/ta1:zipCode" />
				</div>
			</td>
		</tr>
	</table>
	</xsl:template>
</xsl:stylesheet>